function waveForm(timer) {

  
  
  angleMode(DEGREES)
  colorMode(RGB)
  background(0)
  let waveform = fft.waveform();
  let level = amplitude.getLevel();
  let jump = map(level, 0, 1, 0, 0.7)
  let jumpsin = sin((timer*0.01) * jump) * height / 4
  let move = jumpsin + sin(timer*0.01) * height / 4

  noFill();
  beginShape();
  for (let i = 0; i < waveform.length; i++) {
    let x = map(i, 0, waveform.length, -width, width);
    let y = map(waveform[i], 0, -3, 3, width);
    let r = map(level, 0, 0.3, 0, 255)
    let g = map(level, 0, 0.3, 0, 25)
    let b = map(level, 0, 0.3, 0, 25)
    let wg = map(level, 0, 0.3, 0, height/58)
    stroke(r, g, b, huefftvert)
    strokeWeight(wg)
    if (timer > beat*29 && timer < beat*32){
      rotate((timer-(beat*29))*rotatespeed)
      rotatespeed+=0.0000001
    }
    if (timer > beat*31 && timer < beat*32){
      huefftvert-=0.05
      huefftline-=0.008
      hueffthistory-=0.05
    }
    
    vertex(x, y);
    push()
    stroke(huefftline)
    strokeWeight(height/576)
    line(0, move, x, y);
    pop()
     push()
     Trail(x, y);
     pop()

  }
  endShape();
  frames += 0.1
  fill(0)
  stroke(hueffthistory)
  if (timer >= beat*8 && timer <= beat*16){
  text(human[0],0,-height/4)
    
  }
 if (timer >= beat*12 && timer <= beat*16){
    text(human[1],0,-height/5.5)
 }
   if (timer >= beat*20 && timer <= beat*24){
    text(human[2],0,height/5.5)
 }
    
     if (timer >= beat*28 && timer <= beat*32){
    textsize+=timer*0.00002
       text(human[3],0,0)
 }
  
  
}


function Trail(x, y) {

  this.x = x
  this.y = y
  
  let v = createVector(this.x, this.y);
    history.push(v)
    if (history.length > 2) {
      history.splice(0, 1)

    }





    for (let i = 0; i < history.length; i++) {
       history[i].y += random(-3,3);
    }
    
    for (var i = 1; i < history.length; i++) {
      let pos = history[i];
      let wg=map(i,0,history.length,10,1)
      let c=map(i,0,history.length,200,255)
      stroke(hueffthistory,hueffthistory,hueffthistory,c);
      strokeWeight(wg)
      point(pos.x,pos.y)
  }
}